% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize_VL.R
\name{minimize_vl}
\alias{minimize_vl}
\title{Smallest voice leading between two sets}
\usage{
minimize_vl(
  source,
  goal,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  no_ties = FALSE,
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{source}{Numeric vector, the pitch-class set at the start of your voice leading}

\item{goal}{Numeric vector, the pitch-class set at the end of your voice leading}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{no_ties}{If multiple VLs are equally small, should only one be returned? Defaults to \code{FALSE}, which
is generally what an interactive user should want.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric array. In most cases, a vector the same length as \code{source};
or a vector of \code{NA} the same length as \code{source} if \code{goal} and
\code{source} have different lengths. If \code{no_ties=FALSE} and multiple voice leadings
are equivalent, the array can be a matrix with \code{m} rows where \code{m} is the number
of equally small voice leadings.
}
\description{
Given a \code{source} set and a \code{goal} to move to, find the "strongly
crossing-free" voice leading from \code{source} to \code{goal} with smallest size.
}
\examples{
c_major <- c(0, 4, 7)
ab_minor <- c(8, 11, 3)
minimize_vl(c_major, ab_minor)

diatonic_scale <- c(0, 2, 4, 5, 7, 9, 11)
minimize_vl(diatonic_scale, tn(diatonic_scale, 7))

d_major <- c(2, 6, 9)
minimize_vl(c_major, d_major)
minimize_vl(c_major, d_major, no_ties=TRUE)
minimize_vl(c_major, d_major, method="euclidean", no_ties=FALSE)

minimize_vl(c(0, 4, 7, 10), c(7, 7, 11, 2), method="euclidean")
minimize_vl(c(0, 4, 7, 10), c(7, 7, 11, 2), method="euclidean", no_ties=TRUE)
}
