% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/musica.R
\name{decomp}
\alias{decomp}
\title{Decomposition of time-series}
\usage{
decomp(x, period = c("Y1", "M6", "M3", "M1", "D15", "D1"), agg_by = quarter,
  full_return = FALSE, remove_incomplete = TRUE)
}
\arguments{
\item{x}{data.table with columns \code{DTM} (date), \code{variable} and \code{value}. Any number of variables are in principle allowed.}

\item{period}{The periods over which the averages will be calculated, see Details}

\item{agg_by}{Function for specification of the period (season, month) to be additionaly included in output, see Details}

\item{full_return}{(logical) Should the average be repeated for each scale along with original time series? Default is FALSE (e.g. for M1 only monthly and not daily time series is returned)}

\item{remove_incomplete}{Should the incomplete years be removed from results? Default is TRUE}
}
\value{
data.table with variables:
\describe{
 \item{variable}{factor indicating the variable}
 \item{DTM}{date}
 \item{period}{specification of the averaging length with `D` - day(s), `M` - month(s), `Y` - year(s) and `G1` - the overall mean }
 \item{value}{value of the variable for given averaging length}
 \item{sub_period}{indication of the aggregating scale specified by \code{agg_by} argument}
 \item{period_pos}{average date of the interval}
 \item{N}{real length of the vectors used for calculating averages}
 \item{TS}{averaging length in hours}
}
}
\description{
Calculate series of averages over the periods specified in the \code{period} argument into the inpur data.table.
}
\details{
The original time series in daily time step is decomposed into series of averages ove periods specified in \code{periods} argument using letter codes `D` - day(s), `M` - month(s), `Y` - year(s) followed by number corresponding to number of periods and `G1` the overall mean. The periods must be given in order from longest to shortest, the overall mean is always included (and needs not to be specified in \code{period}). Shorter periods are always identified within the closest longer periods, i.e. each shorter period is included in exactly one longer period. As a result, the averages may be calculated over shorter periods than specified. This is due to varying length of "month" and "year" periods. The actual length used for averaging is included in the output. To make further assessment of the decomposed objects easier, indicator of period within the year (e.g. quarter or month) as specified by \code{agg_by} argument is included in the output.
}
\examples{
data(basin_PT)
str(basin_PT)
basin_PT[['obs_ctrl']]
dobs = decomp(basin_PT[['obs_ctrl']], period = c('1 year', '1 month', '1 day'))
}

