/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.backends.rengine;

import java.util.Arrays;
import java.util.List;
import org.af.jhlir.backends.rengine.RCallServicesREngine;
import org.af.jhlir.backends.rengine.RObjectREngine;
import org.af.jhlir.call.RMatrix;
import org.apache.commons.lang.ArrayUtils;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;

public abstract class RMatrixREngine<WRAPPED_TYPE extends REXP, RESOLVED_TYPE extends REXP, ARR_TYPE, EL_TYPE>
extends RObjectREngine<WRAPPED_TYPE, RESOLVED_TYPE>
implements RMatrix<WRAPPED_TYPE, ARR_TYPE, EL_TYPE> {
    public RMatrixREngine(RCallServicesREngine rs, WRAPPED_TYPE wrapped) {
        super(rs, wrapped);
    }

    @Override
    public int getRowCount() {
        try {
            return this.getWrapped().getAttribute("dim").asIntegers()[0];
        }
        catch (REXPMismatchException e) {
            return -1;
        }
    }

    @Override
    public int getColumnCount() {
        try {
            return this.getWrapped().getAttribute("dim").asIntegers()[1];
        }
        catch (REXPMismatchException e) {
            return -1;
        }
    }

    @Override
    public String[] getRowNames() {
        try {
            return this.getWrapped().getAttribute("rownames").asStrings();
        }
        catch (REXPMismatchException e) {
            return null;
        }
    }

    @Override
    public String[] getColNames() {
        try {
            return this.getWrapped().getAttribute("colnames").asStrings();
        }
        catch (REXPMismatchException e) {
            return null;
        }
    }

    @Override
    public List<String> getRowNamesAsList() {
        return Arrays.asList(this.getRowNames());
    }

    @Override
    public List<String> getColNamesAsList() {
        return Arrays.asList(this.getColNames());
    }

    protected int getIndex(int i, int j) {
        return j * this.getRowCount() + i;
    }

    public int getRowIndex(String name) {
        return ArrayUtils.indexOf((Object[])this.getRowNames(), (Object)name);
    }

    public int getColIndex(String name) {
        return ArrayUtils.indexOf((Object[])this.getColNames(), (Object)name);
    }

    protected abstract EL_TYPE[][] createArr(int var1, int var2);

    @Override
    public EL_TYPE[][] getDataAsObjArr() {
        EL_TYPE[][] res = this.createArr(this.getRowCount(), this.getColumnCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                res[i][j] = this.get(i, j);
            }
        }
        return res;
    }

    public EL_TYPE get(int i, String col) {
        int j = ArrayUtils.indexOf((Object[])this.getColNames(), (Object)col);
        return this.get(i, j);
    }

    public EL_TYPE get(String row, int j) {
        int i = ArrayUtils.indexOf((Object[])this.getRowNames(), (Object)row);
        return this.get(i, j);
    }
}

