/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.widgets;

import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.validator.routines.DoubleValidator;

public class PopulationsTableModel
extends AbstractTableModel {
    List<String> header;
    List<Class> type;
    List<Double> defaults;
    List<Double> min;
    List<Double> max;
    public List<List<Double>> data = new Vector<List<Double>>();

    public PopulationsTableModel(List<String> header, List<Class> type, List<Double> defaults, List<Double> min, List<Double> max) {
        this.header = header;
        this.type = type;
        this.defaults = defaults;
        this.min = min;
        this.max = max;
        for (Class c : type) {
            this.data.add(new Vector());
        }
    }

    @Override
    public int getColumnCount() {
        return this.header.size();
    }

    @Override
    public int getRowCount() {
        return this.data.get(0).size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        return this.data.get(c).get(r);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        DoubleValidator validator;
        Double d;
        if (value != null && value instanceof Double && (d = (validator = new DoubleValidator()).validate(value.toString())) > this.min.get(col) && d < this.max.get(col)) {
            this.data.get(col).set(row, d);
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.header.get(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void addLine() {
        int rowcount = this.getRowCount();
        for (int i = 0; i < this.data.size(); ++i) {
            if (rowcount > 0) {
                this.data.get(i).add(this.data.get(i).get(this.data.get(i).size() - 1));
                continue;
            }
            this.data.get(i).add(this.defaults.get(i));
        }
        this.fireTableStructureChanged();
    }

    public void removeLine(int i) {
        for (List<Double> row : this.data) {
            row.remove(i);
        }
        this.fireTableStructureChanged();
    }
}

