% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_branch.R
\name{formula_branch}
\alias{formula_branch}
\title{Create a new formula branch.}
\usage{
formula_branch(..., name = NULL)
}
\arguments{
\item{...}{branch definition expressions.}

\item{name}{Name for the new formula.}
}
\value{
a \code{formula_branch} object.
}
\description{
Create a new formula branch.
}
\examples{
# Define a formula branch.
model_specifications <- formula_branch(
  y ~ femininity,
  y ~ femininity + hurricane_strength,
  y ~ femininity * hurricane_strength
)
# Create a mverse, add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_formula_branch(model_specifications)
}
\seealso{
Other formula branch functions: 
\code{\link{add_formula_branch}()}
}
\concept{formula branch functions}
