% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.mvgam.R
\name{fevd.mvgam}
\alias{fevd.mvgam}
\alias{fevd}
\title{Calculate latent VAR forecast error variance decompositions}
\usage{
fevd(object, ...)

\method{fevd}{mvgam}(object, h = 1, ...)
}
\arguments{
\item{object}{\code{list} object of class \code{mvgam} resulting from a call to \code{\link[=mvgam]{mvgam()}}
that used a Vector Autoregressive latent process model (either as \code{VAR(cor = FALSE)} or
\code{VAR(cor = TRUE)})}

\item{...}{ignored}

\item{h}{Positive \code{integer} specifying the forecast horizon over which to calculate
the IRF}
}
\value{
An object of class \code{mvgam_fevd} containing the posterior forecast error
variance decompositions. This
object can be used with the supplied S3 functions \code{plot}
}
\description{
Compute forecast error variance decompositions from
\code{mvgam} models with Vector Autoregressive dynamics
}
\details{
A forecast error variance decomposition is useful for quantifying the amount
of information each series that in a Vector Autoregression contributes to the forecast
distributions of the other series in the autoregression. This function calculates
the forecast error variance decomposition using the
orthogonalised impulse response coefficient matrices \eqn{\Psi_h}, which can be used to
quantify the contribution of series \eqn{j} to the
h-step forecast error variance of series \eqn{k}:
\deqn{
\sigma_k^2(h) = \sum_{j=1}^K(\psi_{kj, 0}^2 + \ldots + \psi_{kj,
h-1}^2) \quad
}
If the orthogonalised impulse reponses \eqn{(\psi_{kj, 0}^2 + \ldots + \psi_{kj, h-1}^2)}
are divided by the variance of the forecast error \eqn{\sigma_k^2(h)},
this yields an interpretable percentage representing how much of the
forecast error variance for \eqn{k} can be explained by an exogenous shock to \eqn{j}.
}
\examples{
\donttest{
# Simulate some time series that follow a latent VAR(1) process
simdat <- sim_mvgam(family = gaussian(),
                    n_series = 4,
                    trend_model = VAR(cor = TRUE),
                    prop_trend = 1)
plot_mvgam_series(data = simdat$data_train, series = 'all')

# Fit a model that uses a latent VAR(1)
mod <- mvgam(y ~ -1,
             trend_formula = ~ 1,
             trend_model = VAR(cor = TRUE),
             family = gaussian(),
             data = simdat$data_train,
             chains = 2,
             silent = 2)

# Calulate forecast error variance decompositions for each series
fevds <- fevd(mod, h = 12)

# Plot median contributions to forecast error variance
plot(fevds)
}
}
\references{
Lütkepohl, H (2006).
New Introduction to Multiple Time Series Analysis. Springer, New York.
}
\seealso{
\code{\link{VAR}}, \code{\link{irf}}, \code{\link{stability}}
}
\author{
Nicholas J Clark
}
