% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mvtb_summary.R
\name{mvtb.cluster}
\alias{mvtb.cluster}
\title{Clustering the covariance explained or relative influence matrix}
\usage{
mvtb.cluster(x, clust.method = "ward.D", dist.method = "manhattan",
  plot = FALSE, ...)
}
\arguments{
\item{x}{Any table (e.g. \code{object$covex}), \code{mvtb.ri(object)}. If an mvtb object, defaults to \code{object$covex}}

\item{clust.method}{clustering method for rows and columns. See \code{?hclust} for possibilities}

\item{dist.method}{method for computing the distance between two lower triangular covariance matrices. See \code{?dist} for alternatives.}

\item{plot}{Produces a heatmap of the covariance explained matrix. see \code{?mvtb.heat}}

\item{...}{Arguments passed to \code{mvtb.heat}}
}
\value{
clustered covariance matrix, with re-ordered rows and columns.
}
\description{
The 'covariance explained' by each predictor is the reduction in covariance between each pair of outcomes due to splitting on each predictor over all trees (\code{$covex}).
To aid in the interpretability of the covariance explained matrix, this function clusters the rows (pairs of outcomes) and the columns (predictors) of \code{object$covex}
so that groups of predictors that explain similar pairs of covariances are closer together.
This function can also be used to cluster the relative influence matrix. In this case, the rows (usually outcomes) and columns (usually predictors) with similar values will
be clustered together.
}
\details{
The covariance explained by each predictor is only unambiguous if the predictors are uncorrelated and interaction.depth = 1.
If predictors are not independent, the decomposition of covariance explained is only approximate (like the decomposition of R^2 by each predictor in a linear model).
If interaction.depth > 1, the following heuristic is used: the covariance explained by the tree is assigned to the predictor with the largest influence in each tree.

Note that different distances measures (e.g. 'manhattan', 'euclidean') provide different ways to measure distances between
the covariance explained patterns for each predictor. See \code{?dist} for further details.
After the distances have been computed, \code{hclust} is used to form clusters.
Different clustering methods (e.g. "ward.D", "complete") generally group rows and columns differently.
It is suggested to try different distance measures and clustering methods to obtain the most interpretable solution.
The defaults are for 'manhattan' distances and 'ward.D' clustering, which seem to provide reasonable solutions in many cases.
Transposing the rows and columns may also lead to different results.

A simple heatmap of the clustered matrix can be obtained by setting \code{plot=TRUE}. Details of the plotting procedure are available via \code{mvtb.heat}.

\code{covex} values smaller than \code{getOption("digits")} are truncated to 0. Note that it is not impossible to obtain negative variance explained
due to sampling fluctuation. These can be truncated or ignored.
}
\seealso{
\code{mvtb.heat}
}

