% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_dataset.R
\name{trim_dataset}
\alias{trim_dataset}
\title{Internal function to trim input data for \code{mx_dataset()}}
\usage{
trim_dataset(data, slide_id, image_id, marker_cols, metadata_cols = NULL)
}
\arguments{
\item{data}{multiplexed data to normalize. Data assumed to be a data.frame with cell-level data.}

\item{slide_id}{String slide identifier of input \code{data}. This must be a column in the \code{data} data.frame.}

\item{image_id}{String image identifier of input \code{data}. This must be a column in the \code{data} data.frame.}

\item{marker_cols}{vector of column name(s) in \code{data} corresponding to marker values.}

\item{metadata_cols}{other identifiers of the input \code{data} (default=NULL). This must be a vector of column name(s) in the \code{data} data.frame.}
}
\value{
subset of data input to \code{mx_dataset()} (data.frame)
}
\description{
Internal function to trim input data for \code{mx_dataset()}
}
