% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mc_data_heights}
\alias{mc_data_heights}
\title{Default heights of sensors}
\format{
An object of class \code{data.frame} with 13 rows and 4 columns.
}
\usage{
mc_data_heights
}
\description{
This table is used to set the default heights in metadata of sensors based on logger type.
The defaults were set based on the most common uses,
defaults can be overwrite be user. see \link{mc_prep_meta_sensor}
}
\details{
data.frame with columns:
\itemize{
\item logger_type
\item sensor_name
\item height - character representation of height
\item suffix - suffix for sensor_name. If suffix is NA, then sensor_name is not modified.
}

Default heights are:

TOMST - Thermo
\itemize{
\item Thermo_T = air 200 cm
}

TOMST - TMS
\itemize{
\item TMS_T1 = soil 8 cm
\item TMS_T2 = air 2 cm
\item TMS_T3 = air 15 cm
\item TMS_moist = soil 0-15 cm
}

TOMST - Dendro
\itemize{
\item Dendro_T = 130 cm
\item Dendro_raw = 130 cm
}

TOMST - TMS_L45
\itemize{
\item TMS_T1 = soil 40 cm
\item TMS_T2 = soil 30 cm
\item TMS_T3 = air 15 cm
\item TMS_moist = soil 30-44 cm
}

HOBO - HOBO
\itemize{
\item HOBO_T = air 150 cm
\item HOBO_RH = air 150 cm
}
}
\seealso{
\code{\link[=mc_read_files]{mc_read_files()}}, \code{\link[=mc_read_data]{mc_read_data()}}
}
\keyword{datasets}
