% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mc_plot_loggers}
\alias{mc_plot_loggers}
\title{Plot data from loggers}
\usage{
mc_plot_loggers(
  data,
  directory,
  localities = NULL,
  sensors = NULL,
  crop = c(NA, NA)
)
}
\arguments{
\item{data}{myClim object in Raw-format. see \link{myClim-package}}

\item{directory}{path to output directory}

\item{localities}{names of localities; if NULL then all (default NULL)}

\item{sensors}{names of sensors; if NULL then all (default NULL) see \code{names(mc_data_sensors)}}

\item{crop}{datetime range for plot, not cropping if NA (default c(NA, NA))}
}
\value{
PNG files created in the output directory
}
\description{
Function save separate files (*.png) per the loggers to the directory.
Only Raw-format supported, Agg-format not supported.
For Agg-format use \code{\link[=mc_plot_line]{mc_plot_line()}}. Function was primary designed
for Tomst  TMS loggers for fast, and easy data visualization.
}
\examples{
tmp_dir <- file.path(tempdir(), "plot")
mc_plot_loggers(mc_data_example_clean, tmp_dir)
unlink(tmp_dir, recursive=TRUE)
}
