% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_omit_if.R
\name{na_omit_if}
\alias{na_omit_if}
\title{Conditionally omit missing values}
\usage{
na_omit_if(
  x,
  prop = NULL,
  n = NULL,
  consec = NULL,
  n_non = NULL,
  prop_strict = FALSE
)
}
\arguments{
\item{x}{Vector to omit missing values in if checks pass.}

\item{prop}{The maximum proportion (0 to 1) of missing values allowed.}

\item{n}{The maximum number of missing values allowed.}

\item{consec}{The maximum number of consecutive missing values allowed.}

\item{n_non}{The minimum number of \strong{non-missing} values required.}

\item{prop_strict}{A logical (default \code{FALSE}) indicating if the
proportion of missing values must be \strong{strictly} less than
\code{prop} (\code{prop_strict = TRUE}) or only less than \code{prop}
(\code{prop_strict = FALSE}).}
}
\value{
A vector of the same type as \code{x}. Either \code{x} with missing
  values removed if all checks pass, or \code{x} unmodified if any checks
  fail.

  For consistency with \code{\link[stats]{na.omit}}, if missing
  values are removed, the indices of the removed values form an
  \code{na.action} attribute of class \code{omit} in the result.

  If missing values are not removed (because the checks failed or there were
  no missing values in \code{x}) then no \code{na.action} attribute is added.
}
\description{
\code{na_omit_if} removes missing values from \code{x} if the specified
checks are satisfied, and returns \code{x} unmodified otherwise. When used
within summary functions, \code{na_omit_if} provides greater flexibility than
the \code{na.rm} option e.g. \code{sum(na_omit_if(x, prop = 0.05))}.
}
\details{
There are four type of checks available:
\itemize{
\item a maximum proportion of missing values allowed (\code{prop})
\item a maximum number of missing values allowed (\code{n})
\item a maximum number of consecutive missing values allowed (\code{consec}),
and
\item a minimum number of non-missing values required (\code{n_non}).
}

Any number of checks may be specified, including none. If multiple checks are
specified, they must all pass in order for missing values to be
omitted. If no checks are specified then missing values are omitted, since
this is considered as "all" checks passing.
}
\examples{
x <- c(1, 3, NA, NA, NA, 4, 2, NA, 4, 6)

sum(na_omit_if(x, prop = 0.45, n = 10, consec = 5))
sum(na_omit_if(x, prop = 0.45))

require(magrittr)
sum(x \%>\% na_omit_if(prop = 0.45))

# WMO specification for calculating monthly values from daily data
daily_rain <- rnorm(30)
daily_rain[c(3, 5, 6, 7, 8, 9, 24, 28)] <- NA
sum(daily_rain \%>\% na_omit_if(n = 10, consec = 4))
}
