% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na-calculations.R
\name{na_prop}
\alias{na_prop}
\alias{na_n}
\alias{na_consec}
\alias{na_non_na}
\title{Calculate missing value properties}
\usage{
na_prop(x)

na_n(x)

na_consec(x)

na_non_na(x)
}
\arguments{
\item{x}{A vector to calculate the missing values property of.}
}
\value{
Each function returns a number: a proportion (0 to 1) or a count.
}
\description{
A set of functions for calculating missing values properties of a vector.

\itemize{
\item \code{\link{na_prop}}: The proportion of missing values
\item \code{\link{na_n}}: The number of missing values
\item \code{\link{na_consec}}: The maximum number of consecutive missing
values
\item \code{\link{na_non_na}}: The number of non-missing values
}
}
\details{
These functions are used by \code{\link{na_omit_if}} to omit missing values
conditionally on the value of these properties. They are also useful
summaries in their own right.
}
\examples{
na_prop(c(1, 2, NA, 4))

na_prop(c(1:9, NA))

na_n(c(1, 2, NA, 4, NA, NA, 7))

na_n(c(1:9, NA, NA))

na_consec(c(1, NA, NA, NA, 2, NA, NA, 7))

na_consec(c(rep(NA, 5), 1:2, rep(NA, 6)))

na_non_na(c(1, 2, NA, 4, NA, NA, 7))

na_non_na(c(1:9, NA, NA))
}
