% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unname_chunks.R
\name{unname_chunks}
\alias{unname_chunks}
\alias{unname_all_chunks}
\title{Unname chunks in a single file}
\usage{
unname_chunks(path, chunk_name_prefix = NULL)

unname_all_chunks(path, chunk_name_prefix = NULL)
}
\arguments{
\item{path}{Path to file}

\item{chunk_name_prefix}{Character string with prefix of chunknames that will be removed. Default: NULL (indicating all chunknames will be removed except the one named `setup`)}
}
\value{
Always returns TRUE invisibly. Called for side effects.
}
\description{
Unname in a single file all chunks,
or alternatively only unname the chunknames with a given prefix.
In both cases, the chunk name "setup" is preserved, that chunk is never unnamed.
}
\details{
When using namer, please check the edits
 before pushing them to your code base. Such automatic
 chunk labelling is best paired with version control.
}
\examples{
# remove all chunklabels except the one named 'setup'
temp_file_path <- file.path(tempdir(), "test1.Rmd")
file.copy(system.file("examples", "example4.Rmd", package = "namer"),
          temp_file_path,
          overwrite = TRUE)
unname_chunks(temp_file_path)
if(interactive()){
file.edit(temp_file_path)
}
# remove all chunk labels starting with 'example4'
temp_file_path <- file.path(tempdir(), "test2.Rmd")
file.copy(system.file("examples", "example4.Rmd", package = "namer"),
          temp_file_path,
          overwrite = TRUE)
unname_chunks(temp_file_path,chunk_name_prefix='example4')
if(interactive()){
file.edit(temp_file_path)
}
}
