% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_below.R
\name{impute_below}
\alias{impute_below}
\title{Impute data with values shifted 10\% below range.}
\usage{
impute_below(.tbl, prop_below = 0.1, jitter = 0.05, ...)
}
\arguments{
\item{.tbl}{a data.frame}

\item{prop_below}{the degree to shift the values. default is}

\item{jitter}{the amount of jitter to add. default is 0.05}

\item{...}{additional arguments}
}
\value{
an dataset with values imputed
}
\description{
It can be useful in exploratory graphics to impute data outside the range of
the data. \code{impute_below} imputes values 10% below the range for numeric
values, and for character or factor values adds a new string or label.
}
\examples{

# you can impute data like so:
airquality \%>\%
  impute_below()

# However, this does not show you WHERE the missing values are.
# to keep track of them, you want to use `bind_shadow()` first.

airquality \%>\%
  bind_shadow() \%>\%
  impute_below()

# This identifies where the missing values are located, which means you
# can do things like this:

\dontrun{
library(ggplot2)
airquality \%>\%
  bind_shadow() \%>\%
  impute_below() \%>\%
  # identify where there are missings across rows.
  add_label_shadow() \%>\%
  ggplot(aes(x = Ozone,
             y = Solar.R,
             colour = any_missing)) +
  geom_point()
# Note that this ^^ is a long version of `geom_miss_point()`.
}

}
