% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-upset.R
\name{gg_miss_upset}
\alias{gg_miss_upset}
\title{Plot the pattern of missingness using an upset plot.}
\usage{
gg_miss_upset(data, order.by = "freq", ...)
}
\arguments{
\item{data}{data.frame}

\item{order.by}{(from UpSetR::upset) How the intersections in the matrix should be ordered by. Options include frequency (entered as "freq"), degree, or both in any order.  See \code{?UpSetR::upset} for more options}

\item{...}{arguments to pass to upset plot - see \code{?UpSetR::upset}}
}
\value{
a ggplot visualisation of missing data
}
\description{
Upset plots are a way of visualising common sets, \code{gg_miss_upset} shows the
number of missing values for each of the sets of data. The default option
of \code{gg_miss_upset} is taken from \code{UpSetR::upset} - which is to use up to 5
sets and up to 40 interactions. We also set the ordering to by the
frequency of the intersections. Setting \code{nsets = 5} means to look at 5
variables and their combinations. The number of combinations or rather
\code{intersections} is controlled by \code{nintersects}. If there are 40
intersections, there will be 40 combinations of variables explored. The
number of sets and intersections can be changed by passing arguments \code{nsets = 10} to look at 10 sets of variables, and \code{nintersects = 50} to look at 50
intersections.
}
\examples{

\dontrun{
gg_miss_upset(airquality)
gg_miss_upset(riskfactors)
gg_miss_upset(riskfactors, nsets = 10)
gg_miss_upset(riskfactors, nsets = 10, nintersects = 10)
}
}
