% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{remove_redundancy_elements_through_correlation}
\alias{remove_redundancy_elements_through_correlation}
\title{Drop redundant elements (e.g., elements) for which feature (e.g., genes) aboundances are correlated}
\usage{
remove_redundancy_elements_through_correlation(
  .data,
  .element = NULL,
  .feature = NULL,
  .value = NULL,
  correlation_threshold = 0.9,
  top = Inf,
  of_elements = TRUE,
  transform = NULL
)
}
\arguments{
\item{.data}{A tibble}

\item{.element}{A column symbol. The column that is used to calculate distance (i.e., normally elements)}

\item{.feature}{A column symbol. The column that is represents entities to cluster (i.e., normally genes)}

\item{.value}{A column symbol with the value the clustering is based on (e.g., `count`)}

\item{correlation_threshold}{A real number between 0 and 1}

\item{top}{An integer. How many top genes to select}

\item{of_elements}{A boolean}

\item{transform}{A function to use to tranforma the data internalli (e.g., log1p)}
}
\value{
A tibble with redundant elemens removed
}
\description{
Drop redundant elements (e.g., elements) for which feature (e.g., genes) aboundances are correlated
}
\keyword{internal}
