% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointers.R
\name{nanoarrow_pointer_is_valid}
\alias{nanoarrow_pointer_is_valid}
\alias{nanoarrow_pointer_addr_dbl}
\alias{nanoarrow_pointer_addr_chr}
\alias{nanoarrow_pointer_addr_pretty}
\alias{nanoarrow_pointer_release}
\alias{nanoarrow_pointer_move}
\alias{nanoarrow_pointer_export}
\alias{nanoarrow_allocate_schema}
\alias{nanoarrow_allocate_array}
\alias{nanoarrow_allocate_array_stream}
\title{Danger zone: low-level pointer operations}
\usage{
nanoarrow_pointer_is_valid(ptr)

nanoarrow_pointer_addr_dbl(ptr)

nanoarrow_pointer_addr_chr(ptr)

nanoarrow_pointer_addr_pretty(ptr)

nanoarrow_pointer_release(ptr)

nanoarrow_pointer_move(ptr_src, ptr_dst)

nanoarrow_pointer_export(ptr_src, ptr_dst)

nanoarrow_allocate_schema()

nanoarrow_allocate_array()

nanoarrow_allocate_array_stream()
}
\arguments{
\item{ptr, ptr_src, ptr_dst}{An external pointer to a \verb{struct ArrowSchema},
\verb{struct ArrowArray}, or \verb{struct ArrowArrayStream}.}
}
\value{
\itemize{
\item \code{nanoarrow_pointer_is_valid()} returns TRUE if the pointer is non-null
and has a non-null release callback.
\item \code{nanoarrow_pointer_addr_dbl()} and \code{nanoarrow_pointer_addr_chr()} return
pointer representations that may be helpful to facilitate moving or
exporting nanoarrow objects to other libraries.
\item \code{nanoarrow_pointer_addr_pretty()} gives a pointer representation suitable
for printing or error messages.
\item \code{nanoarrow_pointer_release()} returns \code{ptr}, invisibly.
\item \code{nanoarrow_pointer_move()} and \code{nanoarrow_pointer_export()} reeturn
\code{ptr_dst}, invisibly.
\item \code{nanoarrow_allocate_array()}, \code{nanoarrow_allocate_schema()}, and
\code{nanoarrow_allocate_array_stream()} return an
\link[=as_nanoarrow_array]{array}, a \link[=as_nanoarrow_schema]{schema}, and an
\link[=as_nanoarrow_array_stream]{array stream}, respectively.
}
}
\description{
The \link[=as_nanoarrow_schema]{nanoarrow_schema},
\link[=as_nanoarrow_array]{nanoarrow_array},
and \link[=as_nanoarrow_array_stream]{nanoarrow_array_stream} classes are
represented in R as external pointers (\code{EXTPTRSXP}). When these objects
go out of scope (i.e., when they are garbage collected or shortly
thereafter), the underlying object's \code{release()} callback is called if
the underlying pointer is non-null and if the \code{release()} callback is
non-null.
}
\details{
When interacting with other C Data Interface implementations, it is
important to keep in mind that the R object wrapping these pointers is
always passed by reference (because it is an external pointer) and may
be referred to by another R object (e.g., an element in a \code{list()} or as a
variable assigned in a user's environment). When importing a schema,
array, or array stream into nanoarrow this is not a problem: the R object
takes ownership of the lifecycle and memory is released when the R
object is garbage collected. In this case, one can use
\code{\link[=nanoarrow_pointer_move]{nanoarrow_pointer_move()}} where \code{ptr_dst} was created using
\verb{nanoarrow_allocate_*()}.

The case of exporting is more complicated and as such has a dedicated
function, \code{\link[=nanoarrow_pointer_export]{nanoarrow_pointer_export()}}, that implements different logic
schemas, arrays, and array streams:
\itemize{
\item Schema objects are (deep) copied such that a fresh copy of the schema
is exported and made the responsibility of some other C data interface
implementation.
\item Array objects are exported as a shell around the original array that
preserves a reference to the R object. This ensures that the buffers
and children pointed to by the array are not copied and that any references
to the original array are not invalidated.
\item Array stream objects are moved: the responsibility for the object is
transferred to the other C data interface implementation and any
references to the original R object are invalidated. Because these
objects are mutable, this is typically what you want (i.e., you should
not be pulling arrays from a stream accidentally from two places).
}

If you know the lifecycle of your object (i.e., you created the R object
yourself and never passed references to it elsewhere), you can slightly
more efficiently call \code{\link[=nanoarrow_pointer_move]{nanoarrow_pointer_move()}} for all three pointer
types.
}
