% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{send_aio}
\alias{send_aio}
\title{Send Async}
\usage{
send_aio(con, data, mode = c("serial", "raw"), timeout = NULL)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if mode = 'raw').}

\item{mode}{[default 'serial'] to send serialised R objects, or 'raw' to send
atomic vectors of any type as a raw byte vector. For Streams, 'raw' is
the only option and this argument is ignored. Use 'serial' to ensure
perfect reproducibility within R, although 'raw' must be used when
interfacing with external applications which do not understand R
serialisation. Alternatively, for performance, specify an integer position
in the vector of choices i.e. 1L for 'serial' or 2L for 'raw'.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout.}
}
\value{
A 'sendAio' (object of class 'sendAio') (invisibly).
}
\description{
Send data asynchronously over a connection (Socket, Context or Stream).
}
\details{
Async send is always non-blocking and returns a 'sendAio'
    immediately.

    For a 'sendAio', the send result is available at \code{$result}. An
    'unresolved' logical NA is returned if the async operation is yet to
    complete. The resolved value will be zero on success, or else an integer
    error code.

    To wait for and check the result of the send operation, use
    \code{\link{call_aio}} on the returned 'sendAio' object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.
}
\examples{
pub <- socket("pub", dial = "inproc://nanonext")

res <- send_aio(pub, data.frame(a = 1, b = 2), timeout = 100)
res
res$result

res <- send_aio(pub, "example message", mode = "raw", timeout = 100)
call_aio(res)$result

close(pub)

}
