% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{unresolved}
\alias{unresolved}
\title{Query if an Aio is Unresolved}
\usage{
unresolved(aio)
}
\arguments{
\item{aio}{an Aio (object of class 'sendAio' or 'recvAio'), or Aio value
stored in \code{$result}, \code{$raw} or \code{$data} as the case may be.}
}
\value{
Logical TRUE if 'aio' is an unresolved Aio or Aio value, or FALSE
    otherwise.
}
\description{
Query whether an Aio or Aio value remains unresolved. Unlike
    \code{\link{call_aio}}, this function does not wait for completion.
}
\details{
Suitable for use in control flow statements such as \code{while} or
    \code{if}.

    Note: querying resolution may cause a previously unresolved Aio to resolve.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
aio <- send_aio(s1, "test", timeout = 100)

while (unresolved(aio)) {
  # do stuff before checking resolution again
  cat("unresolved\n")
  msleep(20)
}

unresolved(aio)

close(s1)

}
