% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoparquet.R
\name{read_parquet}
\alias{read_parquet}
\title{Read a Parquet file into a data frame}
\usage{
read_parquet(file)
}
\arguments{
\item{file}{Path to a Parquet file.}
}
\value{
A \code{data.frame} with the file's contents.
}
\description{
Converts the contents of the named Parquet file to a R data frame.
}
\examples{
file_name <- system.file("extdata/userdata1.parquet", package = "nanoparquet")
parquet_df <- nanoparquet::read_parquet(file_name)
print(str(parquet_df))
}
\seealso{
See \code{\link[=write_parquet]{write_parquet()}} to write Parquet files,
\link{nanoparquet-types} for the R <-> Parquet type mapping.
See \code{\link[=parquet_info]{parquet_info()}}, for general information,
\code{\link[=parquet_columns]{parquet_columns()}} and \code{\link[=parquet_schema]{parquet_schema()}} for information about the
columns, and \code{\link[=parquet_metadata]{parquet_metadata()}} for the complete metadata.
}
