% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-parquet.R
\name{read_parquet}
\alias{read_parquet}
\title{Read a Parquet file into a data frame}
\usage{
read_parquet(file, col_select = NULL, options = parquet_options())
}
\arguments{
\item{file}{Path to a Parquet file. It may also be an R connection,
in which case it first reads all data from the connection, writes
it into a temporary file, then reads the temporary file, and
deletes it. The connection might be open, it which case it must be
a binary connection. If it is not open, then \code{read_parquet()} will
open it and also close it in the end.}

\item{col_select}{Columns to read. It can be a numeric vector of column
indices, or a character vector of column names. It is an error to
select the same column multiple times. The order of the columns in
the result is the same as the order in \code{col_select}.}

\item{options}{Nanoparquet options, see \code{\link[=parquet_options]{parquet_options()}}.}
}
\value{
A \code{data.frame} with the file's contents.
}
\description{
Converts the contents of the named Parquet file to a R data frame.
}
\examples{
file_name <- system.file("extdata/userdata1.parquet", package = "nanoparquet")
parquet_df <- nanoparquet::read_parquet(file_name)
print(str(parquet_df))
}
\seealso{
See \code{\link[=write_parquet]{write_parquet()}} to write Parquet files,
\link{nanoparquet-types} for the R <-> Parquet type mapping.
See \code{\link[=read_parquet_info]{read_parquet_info()}}, for general information,
\code{\link[=read_parquet_schema]{read_parquet_schema()}} for information about the
columns, and \code{\link[=read_parquet_metadata]{read_parquet_metadata()}} for the complete metadata.
}
