% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/porcelain.R
\name{read_parquet_pages}
\alias{read_parquet_pages}
\title{Metadata of all pages of a Parquet file}
\usage{
read_parquet_pages(file)
}
\arguments{
\item{file}{Path to a Parquet file.}
}
\value{
Data frame with columns:
\itemize{
\item \code{file_name}: file name.
\item \code{row_group}: id of the row group the page belongs to,
an integer between 0 and the number of row groups
minus one.
\item \code{column}: id of the column. An integer between the
number of leaf columns minus one. Note that only leaf
columns are considered, as non-leaf columns do not
have any pages.
\item \code{page_type}: \code{DATA_PAGE}, \code{INDEX_PAGE}, \code{DICTIONARY_PAGE} or
\code{DATA_PAGE_V2}.
\item \code{page_header_offset}: offset of the data page (its header) in the
file.
\item \code{uncompressed_page_size}: does not include the page header, as per
Parquet spec.
\item \code{compressed_page_size}: without the page header.
\item \code{crc}: integer, checksum, if present in the file, can be \code{NA}.
\item \code{num_values}: number of data values in this page, include
\code{NULL} (\code{NA} in R) values.
\item \code{encoding}: encoding of the page, current possible encodings:
"PLAIN", "GROUP_VAR_INT", "PLAIN_DICTIONARY", "RLE", "BIT_PACKED", "DELTA_BINARY_PACKED", "DELTA_LENGTH_BYTE_ARRAY", "DELTA_BYTE_ARRAY", "RLE_DICTIONARY", "BYTE_STREAM_SPLIT".
\item \code{definition_level_encoding}: encoding of the definition levels,
see \code{encoding} for possible values. This can be missing in V2 data
pages, where they are always RLE encoded.
\item \code{repetition_level_encoding}: encoding of the repetition levels,
see \code{encoding} for possible values. This can be missing in V2 data
pages, where they are always RLE encoded.
\item \code{data_offset}: offset of the actual data in the file.
\item \code{page_header_length}: size of the page header, in bytes.
}
}
\description{
Metadata of all pages of a Parquet file
}
\details{
Reading all the page headers might be slow for large files, especially
if the file has many small pages.
}
\examples{
file_name <- system.file("extdata/userdata1.parquet", package = "nanoparquet")
nanoparquet:::read_parquet_pages(file_name)
}
\seealso{
\code{\link[=read_parquet_page]{read_parquet_page()}} to read a page.
}
\keyword{internal}
