% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refMethod.R
\name{refMethod}
\alias{refMethod}
\title{Reference-based approach for batch adjustment}
\usage{
refMethod(Y, R1, R2)
}
\arguments{
\item{Y}{data run in first or second batch, samples are rows and genes are
columns. If correcting one batch only R1 is needed and would correspond to
reference run in the same batch as Y, if calibrating one batch to the other
Y represents the data from batch 2 and R1 would be reference run in batch 1
and R2 would be reference from batch 2}

\item{R1}{reference data run in the first batch}

\item{R2}{reference data run in the second batch}
}
\value{
The Y data adjusted calibrated to batch 1 (if two batches are
presented) or the data with reference sample expression removed if only one
data is provided
}
\description{
Batch adjustment by considering a measure relative to a reference sample
}
\examples{
set.seed(12)
A <- matrix(rnorm(120), ncol = 10)
B <- matrix(rnorm(80), ncol = 10)
C <- matrix(rnorm(50), ncol = 10)
refMethod(A, B, C)
}
\author{
Aline Talhouk
}
