% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtrack.R
\name{emr_vtrack.create_from_name}
\alias{emr_vtrack.create_from_name}
\title{Create a virtual track from an automatically generated name}
\usage{
emr_vtrack.create_from_name(vtrack_name)
}
\arguments{
\item{vtrack_name}{name of a virtual track automatically generated by \code{emr_vtrack.name}. Can be a vector of virtual track names.}
}
\value{
an \code{emr_vtrack} object
}
\description{
Create a virtual track from an automatically generated name
}
\examples{

emr_db.init_examples()
emr_filter.create("f_dense_track", "dense_track", time.shift = c(2, 4))

name <- emr_vtrack.name("dense_track",
    time.shift = 1,
    func = "max",
    filter = "f_dense_track"
)

emr_vtrack.create_from_name(name)
}
\seealso{
\code{\link{emr_vtrack.create}}, \code{\link{emr_vtrack.name}}
}
\keyword{track}
\keyword{~virtual}
