% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sub_score_mat}
\alias{sub_score_mat}
\title{Return scores (or distances) for given query and target neurons}
\usage{
sub_score_mat(query, target, scoremat = NULL, distance = FALSE,
  normalisation = c("raw", "normalised", "mean"))
}
\arguments{
\item{query,target}{character vectors of neuron identifiers.}

\item{scoremat}{a matrix, ff matrix, bigmatrix or a character vector
specifiying the name of an ff matrix containing the all by all score
matrix.}

\item{distance}{logical indicating whether to return distances or scores.}

\item{normalisation}{the type of normalisation procedure that should be
carried out, selected from  \code{'raw'}, \code{'normalised'} or
\code{'mean'} (i.e. the average of normalised scores in both directions).
If \code{distance=TRUE} then this cannot be raw.}
}
\description{
Scores can either be returned as raw numbers, normalised such that a self-hit
has score 1, or as the average of the normalised scores in both the forwards
& reverse directions (i.e. \code{|query->target| + |target->query| / 2}).
Distances are returned as either \code{1 - normscore} in the forwards
direction, or as \code{1 - normscorebar}, where \code{normscorebar} is
\code{normscore} averaged across both directions.
}
\seealso{
\code{\link{sub_dist_mat}}
}

