% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fsutils.r
\name{common_path}
\alias{common_path}
\title{Find common prefix of two or more (normalised) file paths}
\usage{
common_path(paths, normalise = FALSE, fsep = .Platform$file.sep)
}
\arguments{
\item{paths}{Character vector of file paths}

\item{normalise}{Whether to normalise \code{paths} (with
\code{\link{normalizePath}}, default \code{FALSE})}

\item{fsep}{Optional path separator (defaults to \code{.Platform$file.sep})}
}
\value{
Character vector of common prefix, \code{""} when there is no common
  prefix, or the original value of \code{paths} when fewer than 2 paths were
  supplied.
}
\description{
Find common prefix of two or more (normalised) file paths
}
\details{
Note that for absolute paths, the common prefix will be returned
  e.g. \code{common_path(c("/a","/b"))} is \code{"/"}

  Note that \code{\link{normalizePath}} 1) operates according to the
  conventions of the current runtime platform 2) is called with
  \code{winslash=.Platform$file.sep} which means that normalised paths will
  eventually end up separated by "\" by default on Windows rather than by
  "//", which is \code{normalizePath}'s standard behaviour.
}
\examples{
common_path(c("/a","/b"))
common_path(c("/a/b/","/a/b"))
common_path(c("/a/b/d","/a/b/c/d"))
common_path(c("/a/b/d","/b/c/d"))
common_path(c("a","b"))
common_path(c("","/a"))
common_path(c("~","~/"))
common_path(c("~/a/b/d","~/a/b/c/d"), normalise = FALSE)
common_path(c("~","~/"), normalise = FALSE)
}
\seealso{
\code{\link{normalizePath}}

Other path_utils: \code{\link{abs2rel}};
  \code{\link{split_path}}
}

