% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomized_rounding.R
\name{randomized_rounding}
\alias{randomized_rounding}
\title{Sample integer solution from linear programming solution}
\usage{
randomized_rounding(o, N, z, st, st_vals, S)
}
\arguments{
\item{o}{linear programming results, as found in the `o` element of the
returned list from \code{\link{balance_LP}()}.}

\item{N}{the total number of available controls in the data.}

\item{z}{a treatment indicator vector with \code{i}th entry equal to 0 if
unit \code{i} is a control and equal to 1 if unit \code{i} is treated.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{st_vals}{the unique stratum levels contained in \code{st}.}

\item{S}{the number of unique stratum levels contained in \code{st}.}
}
\value{
List containing:
\describe{
\item{\code{controls}}{dataframe with two columns: \code{pr}, which contains
the coefficient determined for that control unit from the linear programming
solution, and \code{select}, a boolean vector stating whether that
control unit was selected for inclusion by randomized rounding.}
\item{\code{selected}}{boolean vector stating whether each unit (both treated
and control) was selected.}
}
}
\description{
The linear programming solution of \code{\link{balance_LP}()} that is used
within \code{\link{optimize_controls}()} sometimes selects fractional control units.
Here, we select any unit the linear programming solution chose with coefficient 1.
Then, we select the remaining required number of units from those that have
fractional solutions by sampling with probabilities equal to the linear
programming solution. Used within \code{\link{optimize_controls}()}.
}
\keyword{internal}
