% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_det_names.R
\name{get_det_names}
\alias{get_det_names}
\title{Get the names in the 'identified.by' column}
\usage{
get_det_names(
  occ,
  identified.by = "identifiedBy",
  freq = FALSE,
  decreasing = TRUE,
  determined.by
)
}
\arguments{
\item{occ}{data frame with occurrence records information.}

\item{identified.by}{column name of \code{occ} with the name of who
determined the species.}

\item{freq}{logical. If \code{TRUE} output contain the number of times each
string is repeated in the \code{identified.by} column. Default = \code{FALSE}}

\item{decreasing}{logical. sort strings in decreasing order of frequency.
Default = \code{TRUE}.}

\item{determined.by}{deprecated, use \code{identified.by} instead.}
}
\value{
character vector containing the strings in \code{identified.by}
    column of \code{occ}. If \code{freq = TRUE} it return a data frame with
    two columns: 'strings' and 'frequency'.
}
\description{
This function facilitates the search for non-taxonomist strings in the
'identified.by' column of occurrence records data set
}
\examples{
data("A.setosa")
get_det_names(A.setosa, freq = TRUE)

}
