% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_main.R
\name{plot.nbc}
\alias{plot.nbc}
\title{Bar plot of top predicted causes from a NBC model}
\usage{
\method{plot}{nbc}(x, top.plot = length(x$causes.pred), min.csmf = 0,
  csmfa.obs = NULL, footnote = TRUE, footnote.color = "gray48",
  footnote.size = 0.7, main = paste("Naive Bayes Classifier: Top ",
  top.plot, " Causes by Predicted CSMF", sep = ""), xlab = "Predicted CSMF",
  col = "dimgray", horiz = TRUE, border = NA, las = 1, ...)
}
\arguments{
\item{x}{A \code{\link{nbc}} object.}

\item{top.plot}{A number that produces top k causes depending on a Cause Specific Mortality Fraction (CSMF) measure.}

\item{min.csmf}{A number that represents the minimum CSMF measure for a cause to be included in the plot.}

\item{csmfa.obs}{A character vector of the true causes for calculating the CSMF accuracy.}

\item{footnote}{A boolean indicating whether to include a footnote containing details about the nbc or not.}

\item{footnote.color}{A character specifying the color of the footnote text.}

\item{footnote.size}{A numeric value specifying the size of the footnote text.}

\item{main}{A character value of the title to display.}

\item{xlab}{A character value of the x axis title.}

\item{col}{A character value of the color to use for the plot.}

\item{horiz}{Set to TRUE to draw bars horizontally and FALSE to draw bars vertically.}

\item{border}{A character value of the colors to use for the bar borders. Set to NA to disable.}

\item{las}{An integer value to determine if labels should be parallel or perpendicular to axis.}

\item{...}{Additional arguments to be passed to \code{\link{barplot}}.}
}
\description{
Plots the results from a \code{\link{nbc}} object as a \code{\link{barplot}} for a number of causes based on
predicted Cause Specific Mortality Fraction (CSMF). \cr \cr
\figure{plotnbcex.png}
}
\details{
See \code{\link{nbc4vaHelpMethods}} for details on CSMF and CSMF accuracy.
}
\examples{
library(nbc4va)
data(nbc4vaData)

# Run naive bayes classifier on random train and test data
train <- nbc4vaData[1:50, ]
test <- nbc4vaData[51:100, ]
results <- nbc(train, test)

# Plot the top 3 causes by CSMF
plot(results, top.plot=3)

}
\seealso{
\code{\link{barplot}}

Other main functions: \code{\link{nbc}},
  \code{\link{print.nbc_summary}},
  \code{\link{summary.nbc}}
}

