% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFGridMapping.R
\docType{class}
\name{CFGridMapping}
\alias{CFGridMapping}
\title{CF grid mapping object}
\description{
This class contains the details for a coordinate reference
system, or grid mapping in CF terms, of a data variable.

When reporting the coordinate reference system to the caller, a character
string in WKT2 format is returned, following the OGC standard.
}
\references{
https://docs.ogc.org/is/18-010r11/18-010r11.pdf
}
\section{Super class}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{CFGridMapping}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{grid_mapping_name}}{The name of the grid mapping.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFGridMapping-new}{\code{CFGridMapping$new()}}
\item \href{#method-CFGridMapping-print}{\code{CFGridMapping$print()}}
\item \href{#method-CFGridMapping-brief}{\code{CFGridMapping$brief()}}
\item \href{#method-CFGridMapping-wkt2}{\code{CFGridMapping$wkt2()}}
\item \href{#method-CFGridMapping-write}{\code{CFGridMapping$write()}}
\item \href{#method-CFGridMapping-clone}{\code{CFGridMapping$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="add_coordinates"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-add_coordinates'><code>ncdfCF::CFObject$add_coordinates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFGridMapping-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFGridMapping-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFGridMapping$new(nc_var, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc_var}}{The netCDF variable that describes this instance.}

\item{\code{name}}{The formal grid mapping name from the attribute.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFGridMapping-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFGridMapping-print}{}}}
\subsection{Method \code{print()}}{
Prints a summary of the grid mapping to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFGridMapping$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFGridMapping-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFGridMapping-brief}{}}}
\subsection{Method \code{brief()}}{
Retrieve a 1-row \code{data.frame} with some information on this
grid mapping.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFGridMapping$brief()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFGridMapping-wkt2"></a>}}
\if{latex}{\out{\hypertarget{method-CFGridMapping-wkt2}{}}}
\subsection{Method \code{wkt2()}}{
Retrieve the CRS string for a specific variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFGridMapping$wkt2(axis_info)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{axis_info}}{A list with information that describes the axes of the
\code{CFVariable} or \code{CFArray} instance to describe.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string with the CRS in WKT2 format.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFGridMapping-write"></a>}}
\if{latex}{\out{\hypertarget{method-CFGridMapping-write}{}}}
\subsection{Method \code{write()}}{
Write the CRS object to a netCDF file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFGridMapping$write(h)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{h}}{Handle to the netCDF file opened for writing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFGridMapping-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFGridMapping-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFGridMapping$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
