%  File man/timePrisim.Rd in package ndtv, part of the Statnet suite
%  of packages for network analysis, http://statnet.org .
%
%  This software is distributed under the GPL-3 license.  It is free,
%  open source, and has the attribution requirements (GPL Section 7) at
%  http://statnet.org/attribution
%
%  Copyright 2012-2016 Statnet Commons
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\name{timePrism}
\alias{timePrism}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot a networkDynamic object as sequence of snapshots in a pseudo-3D space-time prism
}
\description{
Plots an image using \code{\link[scatterplot3d]{scatterplot3d}} to render multiple network layout 'slices' in a '3D'  orthographic projection in which one axis is time. The coordinates for the networks are assumed to have been generated by \code{\link{compute.animation}}
}
\usage{
timePrism(nd, at, 
              spline.v = NULL, 
              spline.col = "#55555555", 
              spline.lwd = 1, 
              box = TRUE, 
              axis = TRUE, 
              planes = FALSE, 
              plane.col = "#FFFFFF99", 
              scale.y = 1, 
              angle = 20, 
              orientation = c("x", "y", "z"), 
              ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{nd}{
 a \code{\link[networkDynamic]{networkDynamic}} object to be plotted
}
  \item{at}{
a numeric vector of times at which the network should be sampled and plotted.
}
  \item{spline.v}{
 optional integer vector of vertex ids to highlight with a spline linking the vertices'' positions at multiple time points
}
  \item{spline.col}{
vector of colors corresponding to \code{spline.v}
}
  \item{spline.lwd}{
numeric line width for vector splines
}
  \item{box}{
a logical value indicating whether a box should be drawn around the plot to indicate its bounds
}
  \item{axis}{
 a logical value indicating whether the x, y, and z axis should be drawn. 
}
  \item{planes}{
 a logical value indicating whether a 'plane' should be drawn to indicate the boundaries of each individual network plot
}
  \item{plane.col}{
a color value to be used to color the planes (usually partially transparent)
}
  \item{scale.y}{
  numeric value giving the relative scale of y axis related to x- and z axis. (may distort network vertex shapes)
}
  \item{angle}{
  numeric angle (degrees) between x and y axis (Attention: result depends on scaling).
}
  \item{orientation}{
three-element charter vector the permutation of which determines the mapping and orientation of the plot axis relative to the figure. i.e. default \code{c('x','y','z')} will place 'z' (the time dimension) 'vertically' up the page, \code{c('z','x','y')} will make the time dimension horizontal, etc. 
}
  \item{\dots}{
additional parameters to \code{\link[network]{plot.network}}
}
}
\details{
Implements a common conceptualization of dynamic networks a series of 'layers' or 'slices' in time. Mostly useful for illustrative purposes as this plot type tends to get really crowded if more than a few network time points are shown, or vertices highlighted. 
}
\value{
invisibly returns the result of the \code{\link[scatterplot3d]{scatterplot3d}} command, which contains  useful functions as \code{$xyz.convert} which can be used to convert xyz coordinates into the plot space for additional annotation. 
}

\author{
skyebend@uw.edu
}
\note{
Not all of the useful argument passthroughs to scatterplot3d and xspline have been implemented yet. Shapes of vertices and edges can be improperly distorted by coordinate projection. 
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
 \code{\link{compute.animation}},\code{\link[scatterplot3d]{scatterplot3d}}, \code{\link{xspline}}, \code{\link[network]{plot.network}}. Also \code{filmstrip} and \code{proxmity.timeline} for related static views. 
}
\examples{
data("short.stergm.sim")
compute.animation(short.stergm.sim)
timePrism(short.stergm.sim,at=c(1,10,20),
          displaylabels=TRUE,
          label.cex=0.5)
          
data(toy_epi_sim)  
timePrism(toy_epi_sim,
          orientation=c('z','y','x'),
          angle=40,
          spline.v=c(7, 29, 36, 70, 82, 96),  # hilite the infected 
          spline.col='red',
          spline.lwd=2,
          box=FALSE,
          planes=TRUE,
          vertex.col='ndtvcol')
}
