% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.intcont.R
\name{neg.intcont}
\alias{neg.intcont}
\title{Negligible Interaction Test for Continuous Predictors}
\usage{
neg.intcont(
  outcome = NULL,
  pred1 = NULL,
  pred2 = NULL,
  eiL,
  eiU,
  standardized = TRUE,
  nbootpd = 1000,
  data = NULL,
  alpha = 0.05,
  plot = TRUE,
  save = FALSE
)
}
\arguments{
\item{outcome}{continuous outcome variable}

\item{pred1}{first continuous predictor variable}

\item{pred2}{second continuous predictor variable}

\item{eiL}{lower limit of the negligible effect (equivalence) interval}

\item{eiU}{upper limit of the negligible effect (equivalence) interval}

\item{standardized}{logical; should the solution be based on standardized variables (and eiL/eiU)}

\item{nbootpd}{number of bootstrap samples for the calculation of the CI for the proportional distance}

\item{data}{optional data file containing the categorical variables}

\item{alpha}{nominal acceptable Type I error rate level}

\item{plot}{logical; should a plot be printed out with the effect and the proportional distance}

\item{save}{logical; should the plot be saved}
}
\value{
A \code{list} containing the following:
\itemize{
  \item \code{intcoef} Interaction coefficient
  \item \code{intcil} Lower bound of the 1-alpha CI for the interaction coefficient
  \item \code{intciu} Upper bound of the 1-alpha CI for the interaction coefficient
  \item \code{eiL} Lower bound of the negligible effect (equivalence) interval
  \item \code{eiU} Upper bound of the negligible effect (equivalence) interval
  \item \code{sprs} Semi-partial correlation squared for the interaction term
  \item \code{PD} Proportional distance
  \item \code{CI95L} Lower bound of the 1-alpha CI for the PD
  \item \code{CI95U} Upper bound of the 1-alpha CI for the PD
  \item \code{alpha} Nominal Type I error rate
}
}
\description{
Testing for the presence of a negligible interaction between two continuous predictor variables
}
\details{
This function evaluates whether the interaction between two continuous predictor variables is negligible. This can be important for deciding whether to remove an interaction term from a model or to evaluate a hypothesis related to negligible interaction.

eiL/eiU represent the bounds of the negligible effect (equivalence) interval (i.e., the minimally meaningful effect size, MMES) and should be set based on the context of the research. When standardized = TRUE, Acock (2014) suggests that the MMES for correlations can also be applied to standardized effects - Acock, A. C. (2014). A Gentle Introduction to Stata (4th ed.). Texas: Stata Press.

User can input the outcome variable and two predictor variable names directly (i.e., without a data statement), or can use the data statement to indicate the dataset in which the variables can be found.

The advantage of this approach when standardized = TRUE and there are only two predictors is that the Delta method is adopted. However, for general cases researchers can also use the neg.reg function.

The proportional distance (interaction coefficient/negligible effect bound) estimates the proportional distance of the effect from 0 to negligible effect bound, and acts as an alternative effect size measure.

The confidence interval for the proportional distance is computed via bootstrapping (percentile bootstrap).
}
\examples{
d<-perfectionism
neg.intcont(outcome = mpshfpre.sop, pred1 = cesdpre.total, pred2 = atqpre.total, data = d,
eiL = -.25, eiU = .25, standardized = TRUE, nbootpd = 100)
}
