% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genNetworkLE.R
\name{genNetworkLE}
\alias{genNetworkLE}
\title{Relocating Links algorithm (RL algorithm)}
\usage{
genNetworkLE(BM = BM, LE = 0.4, size = NULL, symmetric = FALSE)
}
\arguments{
\item{BM}{An image matrix of a blockmodel; of class \code{matrix} with possible values "nul" and "com".}

\item{LE}{Desired level of errors.}

\item{size}{A vector with the values specifying clusters' sizes. The number of elements of this vector must be the same as the number of clusters specified by an image matrix.}

\item{symmetric}{Wheter a symmetric network should be generated.}
}
\value{
A binary network (of class \code{matrix}) with selected blockmodel type and level of errors.
}
\description{
Generate network with a selected blockmodel and level or errors. See details section.
}
\details{
The level of errors (LE) is used to simulate the extent of inconsistencies in blockmodels. It is defined on 
a scale between 0 and 1, where 0 corresponds to an ideal blockmodel, and 1 corresponds to a totally randomised 
network with the same density as in the ideal blockmodel.
}
\examples{
cohesiveBM <- rbind(c("com", "nul"), c("nul", "com"))
network <- genNetworkLE(BM = cohesiveBM, LE = 0.5, size = c(5, 3))
}
\references{
Cugmas, M., Žiberna, A., & Ferligoj, A. (2021). The Relative Fit measure for evaluating a blockmodel. Statistical Methods & Applications, 30(5), 1315-1335.
}
\author{
Marjan Cugmas
}
