% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jfst_distribution.R
\name{jfst}
\alias{jfst}
\alias{djfst}
\alias{pjfst}
\alias{qjfst}
\alias{rjfst}
\title{Jones Faddy's Skew-t Distribution}
\usage{
djfst(x, mu = 0, sigma = 1, alpha = 2, beta = 2, log = FALSE)

pjfst(
  q,
  mu = 0,
  sigma = 1,
  alpha = 2,
  beta = 2,
  lower.tail = TRUE,
  log.p = FALSE
)

qjfst(
  p,
  mu = 0,
  sigma = 1,
  alpha = 2,
  beta = 2,
  lower.tail = TRUE,
  log.p = FALSE
)

rjfst(n, mu = 0, sigma = 1, alpha = 2, beta = 2)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a location parameter.}

\item{sigma}{a scale parameter.}

\item{alpha}{a shape parameter (skewness).}

\item{beta}{a shape parameter (kurtosis).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)
The default value of this parameter is FALSE}

\item{lower.tail}{logical;if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vectors of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{djfst} gives the density , \code{pjfst} gives the distribution function,
\code{qjfst} gives quantiles function, \code{rjfst} generates random numbers.
}
\description{
To calculate density function, distribution funcion, quantile function, and  build data from random generator function 
for the Jones-Faddy's Skew-t Distribution.
}
\details{
Jones-Faddy's Skew-t Distribution 



The Jones-Faddy's Skew-t distribution with parameters \eqn{\mu}, \eqn{\sigma},\eqn{\alpha}, and \eqn{\beta}
has density:
\deqn{f(x |\mu,\sigma,\beta,\alpha)= \frac{c}{\sigma} {\left[{1+\frac{z}{\sqrt{\alpha+\beta+z^2}}}\right]}^{\alpha+\frac{1}{2}}
{\left[{1-\frac{z}{\sqrt{\alpha+\beta+z^2}}}\right]}^{\beta+\frac{1}{2}}}
where \eqn{-\infty<x<\infty,  -\infty<\mu<\infty,  \sigma>0, \alpha>0, \beta>0,} 
\eqn{z =\frac{x-\mu}{\sigma} }, \eqn{ c = {\left[2^{\left(\alpha+\beta-1\right)} {\left(\alpha+\beta\right)^{\frac{1}{2}}} B(a,b)\right]}^{-1} },
}
\examples{
djfst(4, mu=0, sigma=1, alpha=2, beta=2)
pjfst(4, mu=0, sigma=1, alpha=2, beta=2)
qjfst(0.4, mu=0, sigma=1, alpha=2, beta=2)
r=rjfst(10000, mu=0, sigma=1, alpha=2, beta=2)
head(r)
hist(r, xlab = 'jfst random number', ylab = 'Frequency', 
main = 'Distribution of jfst Random Number ')
}
\references{
Jones, M.C. and Faddy, M. J. (2003) A skew extension of the t distribution,
  with applications. Journal of the Royal Statistical Society, 
  Series B, 65, pp 159-174
  
 Rigby, R.A. and Stasinopoulos, M.D. and Heller, G.Z. and De Bastiani, F. 
  (2019) Distributions for Modeling Location, Scale, 
  and Shape: Using GAMLSS in R.CRC Press
}
\author{
Anisa' Faoziah
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
