% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msnburr_distribution.R
\name{msnburr}
\alias{msnburr}
\alias{dmsnburr}
\alias{pmsnburr}
\alias{qmsnburr}
\alias{rmsnburr}
\title{MSNBurr Distribution}
\usage{
dmsnburr(x, mu = 0, sigma = 1, alpha = 1, log = FALSE)

pmsnburr(q, mu = 0, sigma = 1, alpha = 1, lower.tail = TRUE, log.p = FALSE)

qmsnburr(p, mu = 0, sigma = 1, alpha = 1, lower.tail = TRUE, log.p = FALSE)

rmsnburr(n, mu = 0, sigma = 1, alpha = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a location parameter.}

\item{sigma}{a scale parameter.}

\item{alpha}{a shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)
The default value of this parameter is FALSE.}

\item{lower.tail}{logical;if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vectors of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dmsnburr} gives the density , \code{pmsnburr} gives the distribution function,
\code{qmsnburr} gives quantiles function, \code{rmsnburr} generates random  numbers.
}
\description{
To calculate density function, distribution funcion, quantile function, and  build data from random generator function 
for the MSNBurr Distribution.
}
\details{
MSNBurr Distribution 

The MSNBurr distribution with parameters \eqn{\mu}, \eqn{\sigma},and \eqn{\alpha}
has density:
\deqn{f(x |\mu,\sigma,\alpha)=\frac{\omega}{\sigma}\exp{\left(\omega{\left(\frac{x-\mu}{\sigma}\right)}\right)}{{\left(1+\frac{\exp{\left(\omega{(\frac{x-\mu}{\sigma})}\right)}}{\alpha}\right)}^{-(\alpha+1)}}}
where \eqn{-\infty < x < \infty, -\infty < \mu< \infty, \sigma>0, \alpha>0, 
\omega = \frac{1}{\sqrt{2\pi}} {\left(1+\frac{1}{\alpha}\right)^{\alpha+1}}}
}
\examples{
library("neodistr")
dmsnburr(0, mu=0, sigma=1, alpha=0.1)
plot(function(x) dmsnburr(x, alpha=0.1), -20, 3,
main = "Left Skew MSNBurr Density ",ylab="density")
pmsnburr(7, mu=0, sigma=1, alpha=1)
qmsnburr(0.6, mu=0, sigma=1, alpha=1)
r<- rmsnburr(10000, mu=0, sigma=1, alpha=1)
head(r)
hist(r, xlab = 'MSNBurr random number', ylab = 'Frequency', 
main = 'Distribution of MSNBurr Random Number ')
}
\references{
Iriawan, N. (2000). Computationally Intensive Approaches to Inference in Neo-Normal Linear Models. Curtin University of Technology.

Choir, A. S. (2020). The New Neo-Normal Distributions and their Properties. Disertation. Institut Teknologi Sepuluh Nopember.
}
\author{
Achmad Syahrul Choir and Nur Iriawan
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
