% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_filename_parser.R
\name{neon_filename_parser}
\alias{neon_filename_parser}
\title{NEON filename parser}
\usage{
neon_filename_parser(x)
}
\arguments{
\item{x}{vector of NEON filenames}
}
\value{
a data frame in which filenames have been split into metadata
components.  Column names indicate the metadata field code, see details
section for complete descriptions.
}
\description{
Parse filenames into their component metadata.  See details for
definition of each metadata field, or consult the NEON documentation
linked below. \url{https://data.neonscience.org/file-naming-conventions}
}
\details{
\subsection{Metadata components:}{
\itemize{
\item NEON 	A four-character alphanumeric code, denoting the organizational
origin of the data product and identifying the product as
operational; data collected as part of a special data collection
exercise are designated by a separate, unique alphanumeric code
created by the PI.
\item DOM 	A three-character alphanumeric code, referring to the domain of data
acquisition (D01 - D20).
\item SITE  A four-character alphanumeric code, referring to the site of data
acquisition; all sites are designated by a standardized
four-character alphabetic code.
\item DPL 	A three-character alphanumeric code, referring to data product
processing level.
\item PRNUM 	A five-character numeric code, referring to the data product
number (see the Data Product Catalog at
http://data.neonscience.org/data-product-catalog).
\item REV 	A three-digit designation, referring to the revision number of
the data product. The REV value is incremented by 1 each time a
major change is made in instrumentation, data collection protocol,
or data processing such that data from the preceding revision is
not directly comparable to the new.
\item HOR 	A three-character alphanumeric code for Spatial Index #1.
Refers to measurement locations within one horizontal plane.
For example, if five surface measurements were taken, one
at each of the five soil array plots, the number in the HOR
field would range from 001-005.
\item VER 	A three-character alphanumeric code for Spatial Index #2.
Refers to measurement locations within one vertical plane.
For example, if eight temperature measurements are collected,
one at each tower vertical level, the number in the VER field
would range from 010-080.
\item TMI 	A three-character alphanumeric code for the Temporal Index.
Refers to the temporal representation, averaging period, or
coverage of the data product (e.g., minute, hour, month, year,
sub-hourly, day, lunar month, single instance, seasonal, annual,
multi-annual). 000 = native resolution, 001 = native resolution
or 1 minute, 002 = 2 minute, 005 = 5 minute, 015 = 15 minute,
030 = 30 minute, 060 = 60 minutes or 1 hour, 101-103 = native
resolution of replicate sensor 1, 2, and 3 respectively,
999 = Sensor conducts measurements at varied interval depending on air mass.
\item DESC 	An abbreviated description of the data file or table.
\item YYYY-MM 	Represents the year and month of the data in the file.
\item PKGTYPE 	The type of data package downloaded. Options are 'basic',
representing the basic download package, or 'expanded', representing
the expanded download package (see more information below).
\item GENTIME 	The date-time stamp when the file was generated, in UTC.
The format of the date-time stamp is YYYYMMDDTHHmmSSZ.
}
}

\subsection{AOP Products Only  (Airborne Observation Platform):}{
\itemize{
\item FLHTDATE 	Date of flight, YYYYMMDD
\item FLIGHTSTRT 	Start time of flight, YYYYMMDDHH
\item FLHTSTRT 	Start time of flight, YYMMDDHH
\item IMAGEDATETIME 	Date and time of image capture, YYYYMMDDHHmmSS
\item CCCCCC 	Digital camera serial number
\item NNNN 	Sequential number for indexing files
\item NNN 	Planned flightline number
\item R 	Repeat number
\item FFFFFF 	Numeric code for an individual flightline
\item EEEEEE 	UTM easting of lower left corner
\item NNNNNNN 	UTM northing of lower left corner
}
}
}
\references{
https://data.neonscience.org/file-naming-conventions
}
