% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_export.R
\name{neon_import}
\alias{neon_import}
\title{Import a previously exported zip archive of raw NEON files}
\usage{
neon_import(archive, overwrite = TRUE, dir = neon_dir())
}
\arguments{
\item{archive}{path to the zip archive to be imported}

\item{overwrite}{should we overwrite any existing files?}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \code{\link[tools:userdir]{tools::R_user_dir()}}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}
}
\description{
\code{\link[=neon_import]{neon_import()}} only reads in previously saved archives from \code{\link[=neon_export]{neon_export()}}.
This can be useful in cases where
see \code{\link[=neon_download]{neon_download()}} to download data directly from NEON.
}
\examples{

## tempfiles for example purposes only!
archive <- tempfile()
neondir <- tempdir() 


neon_export(archive, dir = neondir)
neon_import(archive)

}
\seealso{
\code{\link[=neon_export]{neon_export()}}
}
