% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ages.R
\name{ages}
\alias{ages}
\alias{ages.download}
\alias{ages.download_list}
\title{Access proxy age data}
\usage{
ages(obj, ...)

\method{ages}{download}(obj, ...)

\method{ages}{download_list}(obj, ...)
}
\arguments{
\item{obj}{an R object from which counts are to be extracted.}

\item{...}{arguments passed to other methods.}
}
\value{
Either a data frame of ages or a list of such objects.
}
\description{
Extracts age information from objects and returns them in a useful format.
}
\details{
Methods are available for "download" and "download_list" objects.
}
\examples{
\dontrun{
ostracodes <- get_dataset(datasettype = 'ostracode')

ostro.dl <- get_download(ostracodes)
ostro.ages <- ages(ostro.dl)
}
}
\author{
Simon Goring
}
