% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_chronology.R
\name{set_chronology}
\alias{set_chronology}
\title{set chronology information for a new record.}
\usage{
set_chronology(
  x = NA,
  chronologyid = NA_integer_,
  notes = NA_character_,
  contact = list(),
  agemodel = NA_character_,
  ageboundolder = NA_integer_,
  ageboundyounger = NA_integer_,
  isdefault = NA_integer_,
  dateprepared = as.Date(character(0)),
  modelagetype = NA_character_,
  chronologyname = NA_character_,
  chroncontrols = data.frame(0)
)
}
\arguments{
\item{x}{Object to be set as a chronology}

\item{chronologyid}{An optional value. Will be assigned a
unique identifier if not provided.}

\item{notes}{Additional notes about the chronology. For more
modern models, often the function call to Bacon or Bchron is added here.}

\item{contact}{A contacts object, identifying the individual(s)
who created the chronology}

\item{agemodel}{A string representing the age model name, for
example "Crummy linear interpolation".}

\item{ageboundolder}{The \code{ageboundolder} is assigned the oldest sample
age rounded up to the nearest 10}

\item{ageboundyounger}{The \code{ageboundyounger} is assigned the oldest
sample age rounded up to the nearest 10}

\item{isdefault}{Defines whether the model is the default for
the collection unit for a particular model age type.}

\item{dateprepared}{The date at which the age model was prepared.}

\item{modelagetype}{The age type for the model. For validation, the models
should be one of the valid Neotoma \code{agetypes}:
\url{https://api.neotomadb.org/v2.0/data/dbtables?table=agetypes}}

\item{chronologyname}{A valid name for the chronology.}

\item{chroncontrols}{A data.frame containing the chronological controls
for the age model.}
}
\value{
\code{chronology} object
}
\description{
Create a new chronology for a record.
Within Neotoma all chronologies have unique numeric
identifiers. Within R, because of the need to use the
identifiers across objects, and because we want to avoid
conflicts between naming systems, a universally unique
identifier (UUID) is created for the object ID.
}
