% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_palette.R
\name{color_palette}
\alias{color_palette}
\title{Color Palettes Used in NEST}
\usage{
color_palette(n = 10, palette = "nest")
}
\arguments{
\item{n}{(\code{numeric} value) \cr
The number of colors to be returned from
the color palettes. Please note the colors will be repeated after
a certain numerical limit per palette:

\itemize{
\item{\code{nest}} {96 colors}
\item{\code{stream}} {38 colors}
\item{\code{viridis}} {49 colors}
\item{\code{accessible}} {18 colors}
}}

\item{palette}{(\code{character} value)\cr
The name of a palette supported by this function

\itemize{
\item{\code{nest}} {A color palette developed by the NEST team representing colors in the NEST logo.}
\item{\code{stream}} {A color palette proposed by the stream documentation of stream version \code{2_05}}
\item{\code{viridis}} {A color palette provided by the \code{viridis::plasma} function.}
\item{\code{accessible}} {A color palette consisting of accessible colors for those with color blindness.}
}}
}
\value{
A list of hex color code
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A standardized color palette to be used for all plots within
the NEST project.
}
\examples{
library(grid)

plot_pal <- function(x) {
  grid.newpage()
  pushViewport(plotViewport(rep(1, 4)))
  pushViewport(viewport(layout = grid.layout(1, ncol = length(x))))
  for (i in seq_along(x)) {
    grid.rect(
      gp = gpar(fill = x[i], col = NA),
      vp = viewport(layout.pos.col = i, layout.pos.row = 1)
    )
  }
}

plot_pal(color_palette(n = 10, palette = "nest"))

plot_pal(color_palette(n = 10, palette = "stream"))

plot_pal(color_palette(n = 10, palette = "viridis"))

plot_pal(color_palette(n = 10, palette = "accessible"))

}
