% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_predict.R
\name{multi_predict.nested_model_fit}
\alias{multi_predict.nested_model_fit}
\title{Nested model predictions across many sub-models}
\usage{
\method{multi_predict}{nested_model_fit}(object, new_data, ...)
}
\arguments{
\item{object}{A \code{nested_model_fit} object produced by
\code{\link[=fit.nested_model]{fit.nested_model()}}.}

\item{new_data}{A data frame - can be nested or non-nested.}

\item{...}{Passed onto \code{\link[parsnip:multi_predict]{parsnip::multi_predict()}}}
}
\value{
A tibble with the same number of rows as \code{new_data}, after it
has been unnested.
}
\description{
\code{\link[parsnip:multi_predict]{parsnip::multi_predict()}} method for nested models. Allows predictions
to be made on sub-models in a model object.
}
\examples{
\dontshow{if (rlang::is_installed("glmnet")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)
library(tidyr)
library(parsnip)
library(glmnet)

data <- filter(example_nested_data, id \%in\% 16:20)

nested_data <- nest(data, data = -id2)

model <- linear_reg(penalty = 1) \%>\%
  set_engine("glmnet") \%>\%
  nested()

fitted <- fit(model, z ~ x + y + a + b, nested_data)

multi_predict(fitted, example_nested_data,
  penalty = c(0.1, 0.2, 0.3)
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[parsnip:multi_predict]{parsnip::multi_predict()}}
}
