% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netSEMp1.R
\name{netSEMp1}
\alias{netSEMp1}
\title{network Structural Equation Modeling (netSEM)}
\usage{
netSEMp1(
  x,
  exogenous = NULL,
  endogenous = NULL,
  nlsInits = data.frame(a1 = 1, a2 = 1, a3 = 1),
  str = FALSE
)
}
\arguments{
\item{x}{A dataframe. By default it considers all columns as exogenous variables, except the first column which stores the system's endogenous variable.}

\item{exogenous, }{by defult it considers all columns as exogenous variables except column number 1, which is the main endogenous response.}

\item{endogenous}{A character string of the column name of the main endogenous OR a numeric number indexing the column of the main endogenous.}

\item{nlsInits}{a data frame of initial vectors for nls. Each column corresponds to a coefficient. The data frame can be generated by the genInit() function. Each row is one initial vector. Currently the only nls function included is y = a + b * exp(c * x).}

\item{str}{A boolean, whether or not this is a 'strength' type problem}
}
\value{
An object of class netSEM, which is a list of the following items:

\itemize{
\item "table": A matrix. For each row, first column is the endogenous variable, second column is the predictor, the other columns show corresponding summary information: Best functional form, R-squared, adj-R-squared, P-value1, P-value2 and P-value3. The P-values correspond to those of estimators of linear regression coefficients. See details. 
\item "bestModels": A matrix. First dimension indicates predictors. The second dimension indicates endogenous variables. The i-jth cell of the matrix stores the name of the best functional form corresponding to the j-th endogenous variable regressed on the i-th predictor.
\item "allModels":  A three dimensional list. The first dimension indicates predictors. The second dimension indicates endogenous variables. Third dimension indicates the fitting results of all 6 functional forms. The i-j-k-th cell of the list stores a "lm" object, corresponding to the j-th endogenous, i-th predictor and the k-th functional form.
}

The object has two added attributes:

\itemize{

\item "attr(res.best, "Step")": A vector. For each variable, it shows in which step it is choosen to be significantly related to endogenous variable.

\item "attr(res.best, "diag.Step")": A matrix. First dimension is predictors; second dimension is endogenous variables. Each cell shows in which step the pairwise relation is being fitted.
}
}
\description{
This function carries out netSEM using principle 1
}
\details{
netSEM builds a network model of multiple continuous variables using principle 1.
Principle 1 determines the univariate relationships in the spirit of the Markovian process. In this case, the relationship between each pair of system variables, including predictors and the system level response is determined with the Markovian property that assumes the value of the current predictor is sufficient in relating to the next level variable, i.e., the relationship is independent of the specific value of the preceding-level variable to the current predictor, given the current value. 
Each pair of variables is tested for sensible (in the domain knowledge sense) paring relation chosen from 7 pre-selected common functional forms in linear regression settings. 
Adjusted R-squared is used for model selection for every pair.

P-values reported in the "res.print" field of the return list contains the P-values of estimators of linear regression coefficients. 
The P-values are ordered in the common order of coefficients, i.e. in the order of increasing exponents. 
For example, in the quadratic functional form y ~ b0 + b1x + b2x^2, the three P-values correspond two those of \\hat{b0}, \\hat{b1} and \\hat{b2}, respectively. 
If there are less than 3 coefficients to estimate, the extra P-value field is filled with NA's.
}
\examples{
## Load the sample acrylic data set
data(acrylic)

## Run netSEM
ans <- netSEMp1(acrylic)
}
