% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rankogram.R
\name{plot.rankogram}
\alias{plot.rankogram}
\title{Plot rankograms}
\usage{
\method{plot}{rankogram}(x, type = "bar", ylim, ylab, ...)
}
\arguments{
\item{x}{An object of class \code{\link{rankogram}}.}

\item{type}{A character string specifying whether a "bar" chart or
a "line" graph should be drawn.}

\item{ylim}{The y limits (min, max) of the plot.}

\item{ylab}{A label for the y-axis.}

\item{\dots}{Additional graphical arguments (ignored at the
moment).}
}
\description{
This function produces a rankogram, i.e., an image plot of ranking
probabilities for all treatments.
}
\details{
This function produces an image plot of ranking probabilities for
all treatments as a bar graph or as a line graph. Treatments are
sorted according to their mean effects.
}
\examples{
data(Woods2010)
p1 <- pairwise(treatment, event = r, n = N, studlab = author,
               data = Woods2010, sm = "OR")
net1 <- netmeta(p1, small.values = "good")

ran1 <- rankogram(net1, nsim = 100)
ran1

plot(ran1)      
plot(ran1, type = "l")      

}
\references{
Salanti G, Ades AE, Ioannidis JP (2011):
Graphical methods and numerical summaries for presenting results
from multiple-treatment meta-analysis: an overview and tutorial.
\emph{Journal of Clinical Epidemiology},
\bold{64}, 163--71
}
\seealso{
\code{\link{rankogram}}
}
\author{
Thodoris Papakonstantinou \email{dev@tpapak.com}
}
