% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orwg.R
\name{orwg}
\alias{orwg}
\alias{orwg.table}
\alias{orwg.igraph}
\alias{orwg.default}
\title{Odds ratio of existence of within-group ties}
\usage{
orwg(object, ...)

\method{orwg}{table}(object, ...)

\method{orwg}{igraph}(object, vattr, ...)

\method{orwg}{default}(object, ...)
}
\arguments{
\item{object}{R object, see Details for available methods}

\item{...}{other arguments passed to/from other methods}

\item{vattr}{character scalar or any vector, name of the vertex attribute or
the attribute itself (as a vector)}
}
\value{
Numeric value of the measure.
}
\description{
Odds ratio for connected, as opposed to disconnected, dyads depending
whether it is between- or within-group, i.e. how much more likely the dyad
will be connected if it is within-group.
}
\details{
The measure takes values, like all odds ratios, from (0; Inf).

If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.
}
\examples{
orwg(WhiteKinship, "gender")
}
\references{
Moody, Jim (2001) "Race, school integration, and friendship segregation in
America", American Journal of Sociology, 107(3):679--377
}
\seealso{
Other segregation measures: 
\code{\link{assort}()},
\code{\link{coleman}()},
\code{\link{ei}()},
\code{\link{freeman}()},
\code{\link{gamix}()},
\code{\link{smi}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
