\name{estimate.mixing}
\alias{estimate.mixing}
\title{construct a mixing model from GoC/RDS data}
\usage{
  estimate.mixing(survey.data, parent.data, traits)
}
\arguments{
  \item{survey.data}{the respondent info}

  \item{parent.data}{the parent info}

  \item{traits}{the names of the traits to build the model
  on}
}
\value{
  a list with two entries: \itemize{ \item \code{mixing.df}
  the data used to estimate the mixing \item
  \code{choose.next.state.fn} a function which can be
  passed a vector of states and will return a draw of a
  subsequent state each entry in the vector \item
  \code{mixing.df} a dataframe (long-form) representation
  of the transition counts used to estimate the transition
  probabilities \item \code{states} a list with an entry
  for each state. within each state's entry are \itemize{
  \item \code{trans.probs} a vector of estimated transition
  probabilities \item \code{trans.fn} a function which,
  when called, randomly chooses a next state with
  probabilities given by the transition probs. }}
}
\description{
  given a dataset with the respondents and a dataset on the
  parents (in many cases the same individuals), and a set
  of relevant traits, estimate mixing parameters and return
  a markov model
}

