% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_impact.R
\name{edge.impact}
\alias{edge.impact}
\title{Edge Impact}
\usage{
edge.impact(input, gamma, nodes = c("all"), binary.data = FALSE,
  weighted = TRUE, split = c("median", "mean", "forceEqual", "cutEqual",
  "quartiles"))
}
\arguments{
\item{input}{a matrix or data frame of observations (not a network/edgelist).
See included example datasets \code{\link{depression}} and \code{\link{social}}.}

\item{gamma}{the sparsity parameter used in generating networks. Defaults to 0.5
for interval data and 0.25 for binary data}

\item{nodes}{indicates which nodes should be tested. Can be given
as a character string of desired nodes (e.g., c("node1","node2")) or as a
numeric vector of column numbers (e.g., c(1,2)).}

\item{binary.data}{logical. Indicates whether the input data is binary}

\item{weighted}{logical. Indicates whether resultant networks preserve
edge weights or binarize edges.}

\item{split}{method by which to split network given non-binary data. "median": median split (excluding the median),
"mean": mean split, "forceEqual": creates equally sized groups by partitioning random median observations
 to the smaller group, "cutEqual": creates equally sized groups by deleting random values
 from the bigger group,"quartile": uses the top and bottom quartile as groups}
}
\value{
\code{edge.impact()} returns a list of class "\code{edge.impact}" which contains:
 \item{impact}{a list of matrices. Each symmetric matrix contains the edge
 impacts for the given node}
 \item{lo}{a list of matrices. Each symmetric matrix contains the edge
 estimates for the given node's lower half}
 \item{hi}{a list of matrices. Each symmetric matrix contains the edge
 estimates for the given node's upper half}
 \item{edgelist}{a list of dataframes. Each dataframe contains an edgelist of
 edge impacts}
}
\description{
Generates a matrix of edge impacts for each specified node. Each scalar in a given
matrix represents the degree to which the level of a node impacts the strength of
a specified edge in the network
}
\details{
For an explanation of impact functions in general, see \code{\link{impact}}.

Edge impact is the change in an edge's value as a function of a given node.
A separate edge impact value is calculated for each edge in the network.

It is highly useful to plot the edge impacts as if they were a network. Positive edges
in the resultant graph can be interpreted as edges that were made more positive by the
given node, and negative edges can be interpreted as edges that were made more negative
by the given node.

The $hi and $lo output of \code{edge.impact} can also be used to quickly visualize
the difference in network structure depending on node level (see examples).
}
\examples{
out <- edge.impact(depression[450:550,1:3], nodes="anhedonia")
\donttest{
out1 <- edge.impact(depression)
out2 <- edge.impact(depression, gamma=0.65,
        nodes=c("sleep_disturbance", "psychomotor_retardation"))
out3 <- edge.impact(social, nodes=c(1:6, 9), binary.data=TRUE)

summary(out1)
plot(out1, nodes="concentration_problems")

# Visualize edge impacts of psychomotor_retardation
# as a single network
plot(out1, nodes="psychomotor_retardation", type.edgeplot="single")

# Visualize the edge impacts of psychomotor_retardation
# as contrast between high and low
plot(out1, nodes="psychomotor_retardation", type.edgeplot="contrast")

# Extract the impact of psychomotor_retardation on a single edge
out1$impact[["psychomotor_retardation"]]["worthlessness", "fatigue"]

# Extract edge impacts of node Dan in edgelist format
out3$edgelist$Dan
}

}
