% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_nifti.R
\name{write_nifti}
\alias{write_nifti}
\title{General NIfTI Writer}
\usage{
write_nifti(nim, filename, ...)
}
\arguments{
\item{nim}{Container for NIfTI Image}

\item{filename}{Filename of image to be written out}

\item{...}{additional arguments, to be passed to \code{\link{writeNifti}} or
\code{\link{writenii}}}
}
\value{
Output from NIfTI writer
}
\description{
Writes out NIfTI files for multiple formats.  Currently,
for \code{nifti} objects and \code{niftiImage} objects from \code{RNifti}
}
\examples{
set.seed(5)
dims = rep(10, 4)
arr = array(rpois(prod(dims), lambda = 2), dim = dims)
nim = oro.nifti::nifti(arr)
tfile = tempfile(fileext = ".nii.gz")
write_nifti(nim, tfile)
rimg = RNifti::readNifti(tfile)
write_nifti(rimg, tfile)
}
