% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_dropped_dimensions.R
\name{replace_dropped_dimensions}
\alias{replace_dropped_dimensions}
\title{Remake Dropped Dimensions}
\usage{
replace_dropped_dimensions(img, inds, orig.dim)
}
\arguments{
\item{img}{Object of class \code{nifti} where image dimensions were dropped.}

\item{inds}{List of length 3 of indices from 
\code{\link{dropEmptyImageDimensions}} or \code{\link{getEmptyImageDimensions}}}

\item{orig.dim}{Original dimension of pre-dropped image. Output image will
have dimensions same as this value}
}
\value{
Object of class \code{\link[oro.nifti]{nifti}}
}
\description{
This function is the reverse of \code{dropEmptyImageDimensions}.
If \code{dropEmptyImageDimensions} was run, and the output is a list, 
usually if \code{keep_ind = TRUE}, this function reverses that.
}
\examples{
\dontrun{
# nim is an object of class nifti
dd = dropEmptyImageDimensions(nim, keep_ind = TRUE)
remake = replace_dropped_dimensions(img = dd$outimg, 
inds = dd$inds,
orig.dim = dd$orig.dim)
all.equal(nim, remake)
}
}
