% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog.R
\name{cog}
\alias{cog}
\title{Image Center of Gravity}
\usage{
cog(img, thresh = 0, ceil = FALSE, warn = TRUE)
}
\arguments{
\item{img}{Object of class nifti}

\item{thresh}{threshold for image, will find \code{img > 0}}

\item{ceil}{Run \code{\link{ceiling}} to force integers (usu for plotting)}

\item{warn}{Produce a warning if the image is empty after thresholding}
}
\value{
Vector of length 3
}
\description{
Find Center of Gravity of Image, after thresholding
}
\examples{
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100), 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
cog(img)
}
