% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distances}
\alias{distances}
\alias{dist_hamming}
\alias{dist_frobenius}
\alias{dist_spectral}
\alias{dist_root_euclidean}
\title{Distances Between Networks}
\usage{
dist_hamming(x, y, representation = "laplacian")

dist_frobenius(x, y, representation = "laplacian")

dist_spectral(x, y, representation = "laplacian")

dist_root_euclidean(x, y, representation = "laplacian")
}
\arguments{
\item{x}{An \code{\link[igraph]{igraph}} object or a matrix representing an
underlying network.}

\item{y}{An \code{\link[igraph]{igraph}} object or a matrix representing an
underlying network. Should have the same number of vertices as \code{x}.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"}, \code{"modularity"} or
\code{"graphon"}. Default is \code{"laplacian"}.}
}
\value{
A scalar measuring the distance between the two input networks.
}
\description{
This is a collection of functions computing the distance between two
networks.
}
\details{
Let \eqn{X} be the matrix representation of network \eqn{x} and \eqn{Y} be
the matrix representation of network \eqn{y}. The Hamming distance between
\eqn{x} and \eqn{y} is given by \deqn{\frac{1}{N(N-1)} \sum_{i,j} |X_{ij} -
Y_{ij}|,} where \eqn{N} is the number of vertices in networks \eqn{x} and
\eqn{y}. The Frobenius distance between \eqn{x} and \eqn{y} is given by
\deqn{\sqrt{\sum_{i,j} (X_{ij} - Y_{ij})^2}.} The spectral distance between
\eqn{x} and \eqn{y} is given by \deqn{\sqrt{\sum_i (a_i - b_i)^2},} where
\eqn{a} and \eqn{b} of the eigenvalues of \eqn{X} and \eqn{Y}, respectively.
This distance gives rise to classes of equivalence. Consider the spectral
decomposition of \eqn{X} and \eqn{Y}: \deqn{X=VAV^{-1}} and \deqn{Y =
UBU^{-1},} where \eqn{V} and \eqn{U} are the matrices whose columns are the
eigenvectors of \eqn{X} and \eqn{Y}, respectively and \eqn{A} and \eqn{B} are
the diagonal matrices with elements the eigenvalues of \eqn{X} and \eqn{Y},
respectively. The root-Euclidean distance between \eqn{x} and \eqn{y} is
given by \deqn{\sqrt{\sum_i (V \sqrt{A} V^{-1} - U \sqrt{B} U^{-1})^2}.}
Root-Euclidean distance can used only with the laplacian matrix
representation.
}
\examples{
g1 <- igraph::sample_gnp(20, 0.1)
g2 <- igraph::sample_gnp(20, 0.2)
dist_hamming(g1, g2, "adjacency")
dist_frobenius(g1, g2, "adjacency")
dist_spectral(g1, g2, "laplacian")
dist_root_euclidean(g1, g2, "laplacian")
}
